

 
/***********************************************************************************************
 *                                                                                             *
 *                     Example_2. ET-REMOTE MP3 COMMAND-Mode By Read Play Time                 *
 *                                                                                             *
 ***********************************************************************************************
 *  Target MCU    : LPC2138 (CP-JRARM7 LPC2138)                                                *
 *       	       : X-TAL : 19.6608 MHz                                                       * 
 *                : PLL Setup = M(3),P(2)	                                                   *
 *                : Run Speed 58.9824 MHz(With PLL)(19.6608MHz x 3 = 58.9824 MHz               *         
 *                : VPB Clock(pclk) = CPU Clock/2 = 58.9824MHz/2 = 29.4912 MHz                 *
 *                : CPU Clock(cclk) = 58.9824 MHz                                              *           
 *                                                                                             *
 * Editor         : uVision3 (V3.60)                                                           *
 * Compiler       : RealView MDK-ARM 3.20        						                       * 
 * Port Interface :                                                                            *
 *																			                   *
 *                : # MCU-ARM7 LPC2138 #                    # ET-REMOTE MP3 #                  *
 *                  --------------------                    -----------------                  *
 * UART0(RS232)   :      P0.1(Rx0)             Connect            Tx                           *
 *                       P0.0(Tx0)             Connect            Rx			               *
 *                       GND                   Connect           GND						   *
 *            	         Baud Rate 9600                                                        *
 * 																				               *
*              3.3V                                                                            *
 *             -+-                                                                             *
 *              |                                                                              *
 *              +------------------+                                                           *
 *              |                  |                                      -DIP SW.MODE         *
 *              |                  |                                       S1=ON ; S2=ON       *
 *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG       *
 *       +------+------+           |               +-------------------+   S1=ON ; S2=OFF      *
 *       |             |       +---+---+   +---+   |                   |   BR:9600             *
 *       |             |       |       |   |   |   |RS232(have-Max232) |                       *
 *       |             | RX0   |       |   |   |   |----+              |                       *
 *       |         P0.1+-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|             *   
 *       |             | TX0   |       |   | |     |   ||              |      /  |             *
 *       |         P0.0+-------|TxI TxO|---+ +-----|*Tx||              +----||   |             *
 *       |             |       |       |           |   ||              |    || SP|             *
 *       |             |       |MAX232 |       +---+*G ||              +----||   |             *
 *       |             |       +---+---+       |   |----+   [Power]    |      \  |             *
 *       |ARM7-LPC2138 |           |           |   |                   |        \|             * 
 *       +------+------+           |           |   |         G  5V     |                       *
 *              |                  |           |   +---------+---+-----+                       * 
 *              |                  |           |             |   |                             *
 *              +------------------+-----------+             |   +--->5V                       *
 *              |                                            |                                 *
 *            --+--                                        --+--                               *
 *             ---                                          ---                                *
 *              -                                            -                                 *
 *                                                                                             *
 * Test Operate    : For Test Program in Micro SD Card must have File Name 'A23_FT1.MP3' and   *
 *                   'A23_FT2.MP3' ;... Begin Set Command For Show play Time then Play File    *
 *                   Name 'A23_FT1.MP3' is time 30 sec. and chang play File Name               *
 *                   'A24_FT2.MP3' is time 1 minute ,Then Return play New first file           *
 *                                                                                             *
 *                                                                                             *
 * Last Update     : 8/June/2012                                                               *  
 * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 *                                                                                             *
 ***********************************************************************************************/

 
#include "LPC213x.h" 	                             
#include "stdio.h"

 char Buf_Time[5]  ; 

 /*************************************
  *         External Function         *
  *************************************/

extern int  sendchar(int ch)   ;  //Function Tx in Serial.c 
extern int  getkey(void)       ;  //Function Rx in Serial.c 
  
 
 /***********************************************
  *                 Function Delay 		        *
  ***********************************************/
 void delay(int cnt)
 {
  int i,j ;
  
      for(i=0;i<cnt;i++)
	    for(j=0;j<cnt;j++);
 }

 
 /*********************************************
  *              Initial UART0                *
  *********************************************
  *      Initial UART0 = 9600,N,8,1 		  *
  *        VPB(pclk)   = 29.4912 MHz    	  *
  *     U0DLM:U0DLL    = 29.4912MHz/[16xBaud] *
  *                    = 26.4912MHz/[16x9600] *
  *                    = 192=0x00C0     	  *
  *********************************************/

 void UART0_Init(void)
  {
    //--------- Initial Uart0 ----------
   
	U0LCR        = 0x83                     ;  //Conroll Uart1:8bit,1stop,None parity,enable Divisor Latch (83)
    U0DLM        = 0x00                     ;  // Program Divisor Latch  for Baud Rate 9600 ,BR:Byte High  
	U0DLL        = 0xC0                     ;  // BR:Byte Low
    U0LCR        = 0x03                     ;  //Diadble Divisor Latch   
    U0IER        = 0x00000001               ;  //Enable RDA Int(Rx).	
	U0FCR        = 0x07                     ;  //Control Uart0 FIFO:FIFO Enable,Reset Tx,Rx FIFO

  }

 
/***********************************************************
 **                     Initial Port                      **
 ***********************************************************/
 
 void Init_Port(void)
  {
  //------ Set GPIO  PIN -------

  PINSEL0 = 0x00000005               ;	   //Set Port0-PIN[2..15] = GPIO;Enable RxD0(P0.1) and TxD0(P0.0)
 
  } 

 
 
/*************************************************************************************
 **                      Check Respond Command From Board MP3                       **
 *************************************************************************************/

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm()
 {
   char buf_cmm[2] ;
   char n,ch ;
   
   do
    {
      do
       {  
         ch = getkey()  		                 ; //Read Data
		 
       }while(ch != '#')                         ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                             //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         buf_cmm[n] = getkey()                   ; //Keep Data 'OK' 
       }
     
    }while((buf_cmm[0]!='O')&&(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }


/*******************************************************
 *                  Read Play Time                     *
 *           Buf_Time[0] = Ascii Minute Byte High      *
 *           Buf_Time[1] = Ascii Minute Byte Low       *
 *           Buf_Time[2] = Ascii :                     *
 *           Buf_Time[3] = Ascii Secound Byte High     *
 *           Buf_Time[4] = Ascii Secound Byte Low      *
 *******************************************************/

void RD_Time()
 {
    unsigned char ch,n ;

      do
       {
         ch = getkey() 				             ; //Read Dat
       }while(ch !='@')                          ; //Check Byte Start of Echo cmm('@')

      for(n=0;n<5;n++)                             //if ch = @ then Keep data 5 byte(MM:SS)
       {
         Buf_Time[n] = getkey()                 ; //Read Data 'MM:SS' 
	
       }   
 }


/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 int main(void) 
  {
    unsigned char enter=0x0D  ;

	Init_Port()       ;
    UART0_Init()      ;
    delay(800)        ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------
  
   printf("*CF=001%c",enter)      ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,1: Display Time
   Echo_Cmm()                     ;   //Check CMM'#OK'

   //------------- Loop Play file by Name -----------
      
    while(1)
     {
      printf("*P2=A23_FT1.MP3%c",enter)      ;   //Sent CMM Play File by Name : 'A23_FT1.MP3'
	  Echo_Cmm()                             ;   //Check CMM'#OK'
	  
	  do
	  {
	    RD_Time()                            ;  //Read Playing Time    
      }while((Buf_Time[0]!='0')||(Buf_Time[1]!='0')||(Buf_Time[3]!='3')||(Buf_Time[4]!='0'))  ;  //Check Play File to 00.30 sec. Give Chang play File    
	  
	
      printf("*P2=A24_FT2.MP3%c",enter)      ;   //Sent CMM Play File by Name : 'A24_FT2.MP3'
	  Echo_Cmm()                             ;   //Check CMM'#OK'

      do
	  {
	    RD_Time()                            ;   //Read Playing Time   
      }while((Buf_Time[0]!='0')||(Buf_Time[1]!='1')||(Buf_Time[3]!='0')||(Buf_Time[4]!='0'))  ; //Check Play File to 01.00 minit. Give Chang play File      
		
	}  // Return Play File New
  }

















